VERSION 5.00
Object = "{C3347FBA-4070-498B-A391-1D5EDA6E0448}#1.0#0"; "ComiLxAx.ocx"
Begin VB.Form main 
   Caption         =   "UnLimited Scan"
   ClientHeight    =   9585
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5805
   LinkTopic       =   "Form1"
   ScaleHeight     =   9585
   ScaleWidth      =   5805
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame4 
      Caption         =   " Description "
      Enabled         =   0   'False
      Height          =   2550
      Left            =   360
      TabIndex        =   27
      Top             =   6840
      Width           =   5055
      Begin VB.TextBox Text1 
         BackColor       =   &H8000000F&
         BorderStyle     =   0  'None
         Enabled         =   0   'False
         Height          =   1965
         Left            =   255
         MultiLine       =   -1  'True
         TabIndex        =   28
         Text            =   "main.frx":0000
         Top             =   375
         Width           =   4515
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   " Result "
      Height          =   2055
      Left            =   360
      TabIndex        =   9
      Top             =   4560
      Width           =   5055
      Begin VB.ComboBox comViewChannel 
         Enabled         =   0   'False
         Height          =   315
         Left            =   2430
         Style           =   2  'Dropdown List
         TabIndex        =   12
         Top             =   375
         Width           =   1395
      End
      Begin VB.Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Data Loss :"
         Height          =   225
         Left            =   855
         TabIndex        =   15
         Top             =   1125
         Width           =   825
      End
      Begin VB.Label lblVmin 
         Caption         =   "10.000"
         Height          =   375
         Left            =   4080
         TabIndex        =   26
         Top             =   1560
         Width           =   735
      End
      Begin VB.Label lblVmax 
         Caption         =   "-10.000"
         Height          =   375
         Left            =   2760
         TabIndex        =   25
         Top             =   1560
         Width           =   735
      End
      Begin VB.Label lblVaverage 
         Caption         =   "0.000"
         Height          =   375
         Left            =   1320
         TabIndex        =   24
         Top             =   1560
         Width           =   495
      End
      Begin VB.Label Label12 
         Alignment       =   1  'Right Justify
         Caption         =   "Vmin :"
         Height          =   255
         Left            =   3420
         TabIndex        =   23
         Top             =   1560
         Width           =   615
      End
      Begin VB.Label Label7 
         Alignment       =   1  'Right Justify
         Caption         =   "Vmax :"
         Height          =   255
         Left            =   2100
         TabIndex        =   22
         Top             =   1560
         Width           =   615
      End
      Begin VB.Label Label11 
         Alignment       =   1  'Right Justify
         Caption         =   "Vaverage :"
         Height          =   255
         Left            =   300
         TabIndex        =   21
         Top             =   1560
         Width           =   975
      End
      Begin VB.Label Label10 
         Caption         =   "%"
         Height          =   165
         Left            =   4035
         TabIndex        =   20
         Top             =   1140
         Width           =   315
      End
      Begin VB.Label lblLoss 
         Alignment       =   1  'Right Justify
         Caption         =   "00.000"
         Height          =   225
         Left            =   480
         TabIndex        =   16
         Top             =   1140
         Width           =   3420
      End
      Begin VB.Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "View Channel :"
         Height          =   315
         Left            =   1080
         TabIndex        =   11
         Top             =   420
         Width           =   1245
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   " Configuration "
      Height          =   2415
      Left            =   360
      TabIndex        =   4
      Top             =   1920
      Width           =   5055
      Begin VB.TextBox txtFrequency 
         Enabled         =   0   'False
         Height          =   375
         Left            =   2160
         TabIndex        =   17
         Text            =   "10000"
         Top             =   1305
         Width           =   1695
      End
      Begin VB.CommandButton btnStart 
         Caption         =   "Start"
         Enabled         =   0   'False
         Height          =   375
         Left            =   765
         TabIndex        =   14
         Top             =   1800
         Width           =   1455
      End
      Begin VB.CommandButton btnStop 
         Caption         =   "Stop"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2625
         TabIndex        =   13
         Top             =   1800
         Width           =   1455
      End
      Begin VB.ListBox lstChannel 
         Columns         =   4
         Enabled         =   0   'False
         Height          =   285
         ItemData        =   "main.frx":0176
         Left            =   2160
         List            =   "main.frx":0178
         Style           =   1  'Checkbox
         TabIndex        =   10
         Top             =   840
         Width           =   2250
      End
      Begin VB.ComboBox comInputRange 
         Enabled         =   0   'False
         Height          =   315
         ItemData        =   "main.frx":017A
         Left            =   2160
         List            =   "main.frx":018A
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   360
         Width           =   1575
      End
      Begin VB.Label Label9 
         Caption         =   "Hz"
         Height          =   255
         Left            =   4095
         TabIndex        =   19
         Top             =   1410
         Width           =   450
      End
      Begin VB.Label Label8 
         Alignment       =   1  'Right Justify
         Caption         =   "Frequency :"
         Height          =   495
         Left            =   360
         TabIndex        =   18
         Top             =   1320
         Width           =   1335
      End
      Begin VB.Label Label4 
         Caption         =   "Volt"
         Height          =   450
         Left            =   4110
         TabIndex        =   8
         Top             =   405
         Width           =   360
      End
      Begin VB.Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   "Input Channel :"
         Height          =   495
         Left            =   360
         TabIndex        =   7
         Top             =   840
         Width           =   1335
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Input Range :"
         Height          =   375
         Left            =   360
         TabIndex        =   6
         Top             =   360
         Width           =   1335
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   " Device Load "
      Height          =   1215
      Left            =   360
      TabIndex        =   0
      Top             =   480
      Width           =   5055
      Begin VB.CommandButton btnLoadDevice 
         Caption         =   "LOAD DEVICE"
         Height          =   360
         Left            =   3090
         TabIndex        =   2
         Top             =   450
         Width           =   1695
      End
      Begin VB.ComboBox comDeviceList 
         Height          =   315
         ItemData        =   "main.frx":01BD
         Left            =   1365
         List            =   "main.frx":01CA
         Style           =   2  'Dropdown List
         TabIndex        =   1
         Top             =   465
         Width           =   1575
      End
      Begin VB.Label Label1 
         Caption         =   "Device List :"
         Height          =   390
         Left            =   285
         TabIndex        =   3
         Top             =   495
         Width           =   1140
      End
   End
   Begin VB.Timer Timer 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   4245
      Top             =   75
   End
   Begin COMILXAXLib.ComiLxAx ComiLxAx 
      Height          =   450
      Left            =   4755
      TabIndex        =   29
      Top             =   75
      Width           =   450
      _Version        =   65536
      _ExtentX        =   800
      _ExtentY        =   800
      _StockProps     =   0
   End
End
Attribute VB_Name = "main"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*****************************************************************************************
'
'   COMI-LX20x ̽ ø UnLimited Continuous Scan ̴.
'
' ̽ ε , Է    Է  ä, ׸ Է  ļ ϰ
' 'Start'ư Ŭϸ ĵ ۵ȴ.
'
' äκ ִ밪, ּҰ, հ Ǿ, Ÿ ս ִ ,
'   Ÿ ,   սǷ ȴ.
'
'*****************************************************************************************


Const BufSize = 10   '  (ü ۻ ƴ϶, äδ 4096 )
Dim SelectedChList() As Long    'õǾ ä ȣ ϴ 迭
Dim DestBuf() As Double     '͸ ޹ 迭
Dim PreCount, SumOfLoss    ' 迭  ĵŸ + 1 (  ĵ ),  սǵŸ
Dim Vaverage(), Vmax(), Vmin() 'äκ Ÿ , ִ밪, ּҰ


'**********α׷ ʱȭ************************************
'
'   ̽ COMI-LX201 õǾ ִ · ʱȭ
'   AD Input Range -10V~10V ʱȭѴ.
'   ä ϴ ޺ڽ äιȣ Ѵ.
'
'*************************************************************

Private Sub Form_Load()
    comDeviceList.ListIndex = 0
    comInputRange.ListIndex = 3
    For i = 0 To 3
        lstChannel.AddItem (i)
    Next i
End Sub


'**********α׷  *************************************
'
'   btnStopư Enabled Ӽ True , ,  ĵ  ĵ ߴѴ.
'   ̽ εϰ α׷ Ѵ.
'
'*************************************************************

Private Sub Form_Unload(Cancel As Integer)
    If (btnStop.Enabled = True) Then Call ComiLxAx.Us2Stop(1)
    ComiLxAx.UnloadDevice
End Sub


'*******************************************************************
'
'   btnLoadDevice_Click() : btnLoadDevice ư ݹԼ
'
'   õ ̽ εѴ.
'   ̽ ε带 ϸ Ʈѵ  ɻ· ش.
'
'*******************************************************************

Private Sub btnLoadDevice_Click()
    ComiLxAx.UnloadDevice
    
    Select Case comDeviceList.ListIndex
        Case 0
            ComiLxAx.DeviceID = COMI_LX201
        Case 1
            ComiLxAx.DeviceID = COMI_LX202
        Case 2
            ComiLxAx.DeviceID = COMI_LX203
    End Select

    success = ComiLxAx.LoadDevice
    
    If (success = True) Then
        comInputRange.Enabled = True
        lstChannel.Enabled = True
        txtFrequency.Enabled = True
        btnStart.Enabled = True
    Else
        Call MsgBox("ش ̽ ϴ..", vbOKOnly)
    End If
End Sub


'**********************************************************************
'
'   lstChannel_Click() : lstChannel Ʈڽ ݹԼ
'
'   4 ä Ͽ , ޼ ϰ,
'   äμ 3 ϰ ǵ Ѵ.
'   ̴ ø  ϻ, ä 4  õǾ ȴ.
'
'**********************************************************************

Private Sub lstChannel_Click()
    If (lstChannel.SelCount > 3) Then
        Call MsgBox("Ͻ äμ 3 ʰϿϴ.", vbOKOnly)
        lstChannel.Selected(lstChannel.ListIndex) = False
    End If
End Sub


'**********************************************************************
'
'   txtFrequency_Change() : txtFrequency ؽƮڽ ݹԼ
'
'   ĵϴ ø ӵ ϴ Ʈ̴.
'   ڰ ƴ ڰ ԷµǴ  üũϰ,   üũѴ.
'
'**********************************************************************

Private Sub txtFrequency_Change()
    If (Not IsNumeric(txtFrequency.Text)) Then txtFrequency.Text = 10000
    If (txtFrequency.Text < 1) Then txtFrequency.Text = 1
    If (txtFrequency.Text > 2000000) Then txtFrequency.Text = 2000000
End Sub


'**********************************************************************
'
'   btnStart_Click() : btnStart ư ݹԼ
'
'   õ ä üũ , InputRange ϰ,
'   õ ä ŭ 迭 ũ⸦ ش.
'   Ʈѵ  Ұɻ· ش.
'     ʱȭ  , ĵ ϰ, Ÿ̸Ӹ ۽Ų.
'
'**********************************************************************

Private Sub btnStart_Click()
    If (lstChannel.SelCount < 1) Then
        Call MsgBox("ä õ ʾҽϴ.", vbOKOnly)
        Exit Sub
    End If
    
    btnLoadDevice.Enabled = False
    comDeviceList.Enabled = False
    comInputRange.Enabled = False
    lstChannel.Enabled = False
    txtFrequency.Enabled = False
    btnStart.Enabled = False
    btnStop.Enabled = True
    comViewChannel.Enabled = True
    
    Select Case comInputRange.ListIndex
        Case 0
            Min = -1: Max = 1
        Case 1
            Min = -2: Max = 2
        Case 2
            Min = -5: Max = 5
        Case 3
            Min = -10: Max = 10
    End Select
    
    ReDim SelectedChList(lstChannel.SelCount - 1)
    ReDim DestBuf(4096, lstChannel.SelCount - 1)
    ReDim Vaverage(lstChannel.SelCount - 1)
    ReDim Vmax(lstChannel.SelCount - 1)
    ReDim Vmin(lstChannel.SelCount - 1)
    
    For i = 0 To 3
        If (lstChannel.Selected(i)) Then
            SelectedChList(tmp) = i
            Call ComiLxAx.AdSetRange(i, Min, Max)
            comViewChannel.AddItem (i)
            tmp = tmp + 1
        End If
    Next i
    comViewChannel.ListIndex = 0
    
    PreCount = 1: SumOfLoss = 0: lblLoss.Caption = "00.000"
    lblVaverage = "0.000": lblVmax = "-10.000": lblVmin = "10.000"
    For i = 0 To lstChannel.SelCount - 1
        Vaverage(i) = 0: Vmax(i) = -10: Vmin(i) = 10
    Next i
    
    Call ComiLxAx.Us2Start(lstChannel.SelCount, SelectedChList(0), txtFrequency.Text, BufSize, 0)
    Timer.Enabled = True
End Sub

'**********************************************************************
'
'   btnStop_Click() : btnStop ư ݹԼ
'
'   ĵ ϰ,  Ʈѵ Է   ִ · .
'
'**********************************************************************

Private Sub btnStop_Click()
    Call ComiLxAx.Us2Stop(1)
    Timer.Enabled = False
    comViewChannel.Clear
    comViewChannel.Enabled = False
    comInputRange.Enabled = True
    lstChannel.Enabled = True
    txtFrequency.Enabled = True
    btnStop.Enabled = False
    btnStart.Enabled = True
    comDeviceList.Enabled = True
    btnLoadDevice.Enabled = True
End Sub


'**********************************************************************
'
'   Timer_Timer() : Timer Ʈ ̺Ʈ ڵ鷯
'
'   äκ, DestBuf(4096, X)  ,
'   Ÿ ս ִٸ,  սǷ  Ÿ ְ,
'   Ÿ ս ٸ, Ÿ м ش. (  ν κ, ڰ ؼ  )
'   comViewChannel  äο  ȭ鿡 ÷ ش.
'
'**********************************************************************

Private Sub Timer_Timer()
    NumOfData = ComiLxAx.Us2RetrvChannel(0, PreCount, 4096, DestBuf(0, 0))
    If (NumOfData = 0) Then Exit Sub    ' 迭 ޵ Ÿ  0 쿡 ν .
    For i = 1 To lstChannel.SelCount - 1    'õ ä 2 ̻ ,  äε ĵۿ  迭 Ÿ ޹޴´.
        Call ComiLxAx.Us2RetrvChannel(i, PreCount, NumOfData, DestBuf(0, i))
    Next i
    
    If (PreCount < (ComiLxAx.Us2DmaCount - BufSize) * 4096) Then    'ĵ۰ Ǿ Ÿս ִ üũѴ.
        Call countLoss
        PreCount = (ComiLxAx.Us2DmaCount * 4096) + 1    'սǵ ,  Ÿ    ĵۿ ִ  κк ޹޵ Ѵ.
    Else
        Call analysis(NumOfData)
        PreCount = PreCount + NumOfData 'սǵ ,     κ  κк ޹޵ Ѵ.
    End If
    
    lblVmax.Caption = Format(Vmax(comViewChannel.ListIndex), "0.000")   ' äο ؼ ȭ鿡 ǥϿ ش.
    lblVmin.Caption = Format(Vmin(comViewChannel.ListIndex), "0.000")
    lblVaverage.Caption = Format(Vaverage(comViewChannel.ListIndex), "0.000")
    lblLoss.Caption = SumOfLoss & " / " & PreCount & Format(SumOfLoss / PreCount * 100, "        00.000")
End Sub


'**********************************************************************
'
'   countLoss() : սǷ ϴ  ν
'
'    ĵ ۿ ޵ ( DmaCount * 4096 )  Ÿ 
'     迭 ޵ ( PreCount - 1 )  Ÿ  Ͽ Ѵ.
'
'**********************************************************************

Private Sub countLoss()
    SumOfLoss = SumOfLoss + ComiLxAx.Us2DmaCount * 4096 - PreCount - 1
End Sub


'**********************************************************************
'
'   analysis(ByVal NumOfData As Long) : о Ÿ мϴ  ν
'
'   Ķ NumOfData : Long  ̹ Ÿ̸    迭 ޵ Ÿ 
'       ( ByVal :   ȣ   ȣϴ   ǵ  ؾ ϱ ̴.
'               ̴ ø  ϻ, κ ByRef   ȣ Ѵ.)
'   ִ밪 ּҰ, ׸ հ  äκ Ѵ.
'
'**********************************************************************

Private Sub analysis(ByVal NumOfData As Long)
    For ch = 0 To lstChannel.SelCount - 1
        tmpSum = 0
        For i = 0 To NumOfData - 1
            If (Vmax(ch) < DestBuf(i, ch)) Then
                Vmax(ch) = DestBuf(i, ch)
            Else
                If (Vmin(ch) > DestBuf(i, ch)) Then
                    Vmin(ch) = DestBuf(i, ch)
                End If
            End If
            tmpSum = tmpSum + DestBuf(i, ch)
        Next i
        Vaverage(ch) = ((Vaverage(ch) * (PreCount - 1)) + tmpSum) / (PreCount + NumOfData - 1)
    Next ch
End Sub
